clear();
clc();
close all;                              											%Plots schließen
fprintf("Achtung Programm nur für die Funktion A*e^(-B*x) gültig!\n");

%KONFIGURATION---------------------------------------------------------------------
aWERTETABELLE(1,:)  =["Xi", 30.0,   64.5,   74.5,   86.7,   94.5,   98.9];
aWERTETABELLE(2,:)  =["Yi", 4,      18,     29,     51,     73,     90];
F(1)                ={@(x) x};     													%Ansatzfunktionen (Cell array notwendig)
F(2)                ={@(x) 1};     													%Ansatzfunktionen (Cell array notwendig)
sKommastellenDouble = '%.8f';      													%Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen
lambda              ="Lambda";

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_WERTE = size(aWERTETABELLE,2)-1;                                            %Gibt die Anzahl der Spalten zurück (Parameter 2) abzüglich 1 (Der Bezeichner der Wertereihe)
iANZAHL_ANSATZFUNKTIONEN=size(F,2);
if(iANZAHL_ANSATZFUNKTIONEN > iANZAHL_WERTE)
   fprintf("Scotty, wir haben ein Problem!\n");
   fprintf("Es gibt weniger Wertepaare als Ansatzgleichungen !\n"); 
   return;                                                                          %Beendet hoffentlich dsa Programm
end

%INITIALISIERUNG-------------------------------------------------------------------
for(i=1:1:iANZAHL_ANSATZFUNKTIONEN)
    LAMBDA(i)=strcat(lambda,num2str(i));
end

%TRANSFORMATION_WERTETABELLE_IN_LOGARRITHMISCHEN_BEREICH---------------------------
for(i=1:1:iANZAHL_WERTE)
    aWERTETABELLE(2,i+1)  =num2str(log(str2double(aWERTETABELLE(2,i+1))),sKommastellenDouble);
end

%BERECHNUNG------------------------------------------------------------------------
aLGS1="";                                                                           %Initialisierung notwendig
for(i=1:1:iANZAHL_WERTE)                                                            %Regelt die Zeilenabfertigung
    for(j=1:1:iANZAHL_ANSATZFUNKTIONEN)                                             %Regelt die Spaltenabfertigung
        aLGS1(i,j)=num2str(F{j}(str2double(aWERTETABELLE(1,i+1))),sKommastellenDouble);
    end
    aLGS1(i,iANZAHL_ANSATZFUNKTIONEN+1)="";
    aLGS1(i,iANZAHL_ANSATZFUNKTIONEN+2)=num2str(str2double(aWERTETABELLE(2,i+1)),sKommastellenDouble);
end
for(i=1:1:iANZAHL_ANSATZFUNKTIONEN) 
    aLGS1(floor((iANZAHL_WERTE-iANZAHL_ANSATZFUNKTIONEN)/2)+i,iANZAHL_ANSATZFUNKTIONEN+1)=LAMBDA(i);
end
fprintf("Erstes Dingsda = \n");
disp(aLGS1);

%BERECHNUNG_GLEICHUNGSSYSTEM-------------------------------------------------------
aA=str2double(aLGS1(1:iANZAHL_WERTE,1:iANZAHL_ANSATZFUNKTIONEN));
aAT=aA.';                                                                           %Berechnung transponierte Matrix
aY=str2double(aLGS1(1:iANZAHL_WERTE,size(aLGS1,2)));                                %Ergebnisvektor
aATA=aAT*aA;                                                                        %Berechnung transponierte Matrix * Matrix
aATY=aAT*aY;                                                                        %Berechnung transponierte Matrix * Ergebnisvektor
aLGS="";                                                                            %Initialisierung notwendig
for(i=1:1:iANZAHL_ANSATZFUNKTIONEN)                                                 %Regelt die Zeilenabfertigung
    for(j=1:1:iANZAHL_ANSATZFUNKTIONEN)                                             %Regelt die Spaltenabfertigung
        aLGS(i,j)=num2str(aATA(i,j),sKommastellenDouble);
    end
    aLGS(i,iANZAHL_ANSATZFUNKTIONEN+1)=LAMBDA(i);
    aLGS(i,iANZAHL_ANSATZFUNKTIONEN+2)=num2str(aATY(i),sKommastellenDouble);
end
fprintf("Gleichungssystem = \n");
disp(aLGS);

%AUFLÖSUNG_NACH_GAUß---------------------------------------------------------------
aAUFLOESUNG=aLGS;
%DREIECKSZERLEGUNG-----------------------------------------------------------------
for(i=1:1:iANZAHL_ANSATZFUNKTIONEN-1)
    %PIVOTISIERUNG-----------------------------------------------------------------
    [Maximalwert,Zeilenindex]=max(abs(str2double(aAUFLOESUNG(i:end,i))));           %Durchsucht die i-te Spalte startend von Zeile i des Gleichungssystems nach dem maximalen Betrag und gibt (im Falle mehrerer Maximalwerte) den ersten Zeilenindex zurück
    Zeilenindex=Zeilenindex+i-1;                                                    %Korrektur, weil der Vektor in der max-Abfrage um die i-te Zeile schleifenweise sukzessive verkleinert wird
    Zwischenspeicher = aAUFLOESUNG(Zeilenindex,:);
    aAUFLOESUNG(Zeilenindex,:)=aAUFLOESUNG(i,:);
    aAUFLOESUNG(i,:)=Zwischenspeicher;

    %VERBLEIBENDE_GLEICHUNGEN_ABARBEITEN-------------------------------------------
    for(j=i+1:1:iANZAHL_ANSATZFUNKTIONEN)                                           %Startgleichung = i+1, weil die erste Gleichung in der man rechnet die Gleichung 2 ist; Ende = Anzahl Gleichungen Gleichungssystem
        Quotient = str2double(aAUFLOESUNG(j,i))/str2double(aAUFLOESUNG(i,i));       %Nimmt die i-te Spalte, weil mit Durchlaufen oberster for-Schleife die linken Spalten sukzessive 0 werden
        
        %ELEMENTE_DER_GLEICHUNGEN_ABARBEITEN---------------------------------------
        for(k=i:1:(iANZAHL_ANSATZFUNKTIONEN))
            aAUFLOESUNG(j,k) = num2str(str2double(aAUFLOESUNG(j,k)) - Quotient*str2double(aAUFLOESUNG(i,k)),sKommastellenDouble);
        end
        aAUFLOESUNG(j,size(aAUFLOESUNG,2)) = num2str(str2double(aAUFLOESUNG(j,size(aAUFLOESUNG,2))) - Quotient*str2double(aAUFLOESUNG(i,size(aAUFLOESUNG,2))),sKommastellenDouble);
    end
end
fprintf("zerlegtes Lineares Gleichungssystem = \n");
disp(aAUFLOESUNG);

%RÜCKWÄRTSAUFLÖSUNG----------------------------------------------------------------------------
for(i=iANZAHL_ANSATZFUNKTIONEN:-1:1)
    Zwischenspeicher=0;
    for(j=i+1:1:iANZAHL_ANSATZFUNKTIONEN)
        Zwischenspeicher=Zwischenspeicher+(str2double(aAUFLOESUNG(i,j))*str2double(aLAMBDA(j,size(aLAMBDA,2))));
    end
    aLAMBDA(i,1)=LAMBDA(i);
    aLAMBDA(i,2)="=";
    aLAMBDA(i,3)=num2str((str2double(aAUFLOESUNG(i,size(aAUFLOESUNG,2)))-Zwischenspeicher)/str2double(aAUFLOESUNG(i,i)),sKommastellenDouble);
end
aLAMBDA=sortrows(aLAMBDA);                                                              %Sortiert die Lambdas mit der Bezeichnung aufsteigend (1, 2, 3, 4, 5, ...)
fprintf("X-Lösungsvektor = \n");
disp(aLAMBDA);

%FORMATIERUNG_AUSGANGSGLEICHUNG---------------------------------------------------
aBUCHSTABEN(:)= ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];
FORMEL(1,1)=    ["f(x)="];
sSUCHE(1,:)=    ["@(x)" ,"x."   ,"x)."];
sERSETZE(1,:)=  [""     ,"x"    ,"x)"];
for(i=1:1:iANZAHL_ANSATZFUNKTIONEN)
    FORMEL(1,2*i)=strcat("+",aBUCHSTABEN(i));
    Term=func2str(F{i});
    for(j=1:1:size(sSUCHE,2))
        Term=strrep(Term,sSUCHE(j),sERSETZE(j));
    end
    FORMEL(1,(2*i)+1)=strcat("*",Term);
end
FORMEL(2,:)=FORMEL(1,:);
for(i=1:1:iANZAHL_ANSATZFUNKTIONEN)
    FORMEL(2,2*i)=aLAMBDA(i,size(aLAMBDA,2));
    if(str2double(FORMEL(2,2*i))>=0)
        FORMEL(2,2*i)=strcat("+",FORMEL(2,2*i));
    end
end
fprintf("Ausgleichsfunktion = \n");
disp(FORMEL);

%RÜCKTRANSFORMATION_IN_lINEAREN_BEREICH---------------------------------------------
fprintf("Ausgleichsfunktion im linearen y-Raum = \n");
FORMEL_LOG(1,:)=    ["f(x)=","e^a","*","e^(b*x)",""];
FORMEL_LOG(2,:)=    ["f(x)=",strcat("e^",FORMEL(2,2)),"*",strcat("e^(",FORMEL(2,4),"*x)"),""];
FORMEL_LOG(3,:)=    ["f(x)=",num2str(exp(str2double(FORMEL(2,2))),sKommastellenDouble),"*",strcat("e^(",FORMEL(2,4),"*x)"),""];
disp(FORMEL_LOG);

%ERGEBNISPLOT----------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X=min(str2double(aWERTETABELLE(1,2:end))):(max(str2double(aWERTETABELLE(1,2:end)))-min(str2double(aWERTETABELLE(1,2:end))))/Inkrement:max(str2double(aWERTETABELLE(1,2:end)));
Y                   = @(x) str2double(FORMEL_LOG(3,2))*exp(str2double(FORMEL(2,4))*x);
scatter(aWERTETABELLE(1,2:end),aWERTETABELLE(2,2:end),100,'o');
hold on;                                																%Warten bis zur Plotausgabe
Offset=0.1;
text(str2double(aWERTETABELLE(1,2:end))+Offset,str2double(aWERTETABELLE(2,2:end))+Offset,cellstr(strcat(aWERTETABELLE(1,2:end)," | ",aWERTETABELLE(2,2:end))));
hold on;                               																 	%Warten bis zur Plotausgabe
plot(X,Y(X),'color','blue');
FORMELTEXT="";
for(i=1:1:size(FORMEL,2))
    FORMELTEXT=strcat(FORMELTEXT,FORMEL_LOG(3,i));
end
text(X(1)+Offset,Y(1)+5,cellstr(FORMELTEXT));
hold on;                                																%Warten bis zur Plotausgabe
plot(X,xACHSE(X),'color','black');
grid on;                                																%Warten bis zur Plotausgabe
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE aLGS1 aA aAT aATA aATY aLGS aAUFLOESUNG aLAMBDA FORMEL FORMEL_LOG X Y  	%Workspace aufräumen

